/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponentCategoryType;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollapsedCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientList;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionMutableWrapper;

public class IngredientCollectionQuantitativeGrouper<T, M, I extends IIngredientList<T, M> & IIngredientCollectionMutable<T, M>>
extends IngredientCollectionMutableWrapper<T, M, I>
implements IIngredientCollapsedCollectionMutable<T, M> {
    private final IngredientComponentCategoryType<T, M, ?> primaryQuantifier;
    private final M quantifierlessMatchCondition;
    private final long maxQuantity;

    public IngredientCollectionQuantitativeGrouper(I innerCollection, boolean ignoreInnerCollectionEmptyCheck) {
        super(innerCollection);
        if (!ignoreInnerCollectionEmptyCheck && !innerCollection.isEmpty()) {
            throw new IllegalArgumentException("Inner collections must be empty before grouping.");
        }
        this.primaryQuantifier = this.getComponent().getPrimaryQuantifier();
        if (this.primaryQuantifier == null) {
            throw new IllegalArgumentException("Quantitative grouping requires a primary quantifier on the component type.");
        }
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        this.quantifierlessMatchCondition = matcher.withoutCondition(matcher.getExactMatchCondition(), this.getPrimaryQuantifier().getMatchCondition());
        this.maxQuantity = matcher.getMaximumQuantity();
    }

    public IngredientCollectionQuantitativeGrouper(I innerCollection) {
        this(innerCollection, false);
    }

    protected IngredientComponentCategoryType<T, M, ?> getPrimaryQuantifier() {
        return this.primaryQuantifier;
    }

    protected M getQuantifierlessMatchCondition() {
        return this.quantifierlessMatchCondition;
    }

    @Override
    public boolean contains(T instance) {
        Iterator<T> it = this.iterator(instance, this.getQuantifierlessMatchCondition());
        if (!it.hasNext()) {
            return false;
        }
        T first = it.next();
        if (it.hasNext()) {
            return true;
        }
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        return matcher.getQuantity(instance) <= matcher.getQuantity(first);
    }

    @Override
    public boolean containsAll(Iterable<? extends T> instances) {
        for (T instance : instances) {
            if (this.contains(instance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(T instance) {
        Iterator<T> it = this.iterator(instance, this.getQuantifierlessMatchCondition());
        while (it.hasNext()) {
            IIngredientMatcher matcher = this.getComponent().getMatcher();
            T existing = it.next();
            long remainingAllowedQuantity = this.maxQuantity - matcher.getQuantity(existing);
            long newQuantity = matcher.getQuantity(instance);
            if (remainingAllowedQuantity == 0L) continue;
            if (remainingAllowedQuantity >= newQuantity) {
                it.remove();
                long combinedQuantity = Math.addExact(matcher.getQuantity(existing), matcher.getQuantity(instance));
                Object joinedInstance = matcher.withQuantity(instance, combinedQuantity);
                return super.add(joinedInstance);
            }
            it.remove();
            long remainingQuantity = newQuantity - remainingAllowedQuantity;
            return super.add(matcher.withQuantity(existing, this.maxQuantity)) & super.add(matcher.withQuantity(instance, remainingQuantity));
        }
        return super.add(instance);
    }

    @Override
    public boolean addAll(Iterable<? extends T> instances) {
        boolean changed = false;
        for (T instance : instances) {
            changed |= this.add(instance);
        }
        return changed;
    }

    @Override
    public boolean remove(T instance) {
        ArrayList existingInstances = Lists.newArrayList(this.iterator(instance, this.getQuantifierlessMatchCondition()));
        if (existingInstances.isEmpty()) {
            return false;
        }
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        existingInstances.sort((o1, o2) -> (int)(matcher.getQuantity(o1) - matcher.getQuantity(o2)));
        boolean hasMaxInstance = existingInstances.size() > 1;
        long toSubtract = matcher.getQuantity(instance);
        for (Object existing : existingInstances) {
            long existingQuantity = matcher.getQuantity(existing);
            if (existingQuantity > toSubtract) {
                super.remove(existing);
                super.add(matcher.withQuantity(instance, existingQuantity - toSubtract));
                return true;
            }
            if (existingQuantity == toSubtract) {
                super.remove(existing);
                return true;
            }
            if (!hasMaxInstance) {
                return false;
            }
            super.remove(existing);
            toSubtract -= existingQuantity;
        }
        throw new IllegalStateException("Failed to remove due to invalid instance grouping: " + existingInstances);
    }

    @Override
    public int removeAll(T instance, M matchCondition) {
        Iterator<T> it = this.iterator(instance, matchCondition);
        int count = 0;
        while (it.hasNext()) {
            it.next();
            it.remove();
            ++count;
        }
        return count;
    }

    @Override
    public int removeAll(Iterable<? extends T> instances) {
        int removed = 0;
        for (T instance : instances) {
            if (!this.remove(instance)) continue;
            ++removed;
        }
        return removed;
    }

    @Override
    public int removeAll(Iterable<? extends T> instances, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            int size = this.size();
            this.clear();
            return size;
        }
        int removed = 0;
        for (T instance : instances) {
            removed += this.removeAll(instance, matchCondition);
        }
        return removed;
    }
}

